#pragma once
/*
 * Terminus Font
 *
 * Copyright 2010 Dimitar Toshkov Zhekov
 * Copyright 2011 Tilman Blumenbach
 *
 * SPDX-License-Identifier: OFL-1.1
 */

#ifdef MULTIPASS_ARCH_arduino_nano
#include <avr/pgmspace.h>
#define GLYPH_ATTR PROGMEM
#else
#define GLYPH_ATTR
#endif

typedef const unsigned char glyph_line_t;
typedef const unsigned char* glyph_t;

glyph_line_t GLYPH_ATTR chr24_032[] = {0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; // <space>
glyph_line_t GLYPH_ATTR chr24_033[] = {0x03,0xf0,0x9f,0x03}; // !
glyph_line_t GLYPH_ATTR chr24_034[] = {0x0f,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00}; // "
glyph_line_t GLYPH_ATTR chr24_035[] = {0x18,0x00,0x21,0x00,0x00,0x21,0x00,0xf0,0xff,0x03,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0xf0,0xff,0x03,0x00,0x21,0x00}; // #
glyph_line_t GLYPH_ATTR chr24_036[] = {0x15,0xc0,0x87,0x01,0x20,0x0c,0x01,0x20,0x0c,0x01,0xf8,0xff,0x07,0x20,0x0c,0x01,0x60,0x88,0x01,0xc0,0xf8,0x00}; // $
glyph_line_t GLYPH_ATTR chr24_037[] = {0x18,0x40,0x00,0x01,0xf0,0xc0,0x01,0xa0,0x70,0x00,0xe0,0x9c,0x00,0x00,0xc7,0x03,0xc0,0x41,0x01,0x70,0xc0,0x01,0x10,0x00,0x00}; // %
glyph_line_t GLYPH_ATTR chr24_038[] = {0x18,0xc0,0xf1,0x01,0xe0,0x1b,0x03,0x30,0x0e,0x03,0x30,0x0c,0x03,0x30,0x1b,0x03,0xe0,0xb3,0x01,0x00,0xf0,0x01,0x00,0x18,0x03}; // &
glyph_line_t GLYPH_ATTR chr24_039[] = {0x03,0x78,0x00,0x00}; // '
glyph_line_t GLYPH_ATTR chr24_040[] = {0x0c,0x00,0x3f,0x00,0xc0,0xff,0x00,0x60,0x80,0x01,0x30,0x00,0x03}; // (
glyph_line_t GLYPH_ATTR chr24_041[] = {0x0c,0x30,0x00,0x00,0x70,0x80,0x01,0xc0,0xc0,0x00,0x80,0x7f,0x00}; // )
glyph_line_t GLYPH_ATTR chr24_042[] = {0x18,0x80,0x0c,0x00,0x80,0x6d,0x00,0x00,0x3f,0x00,0x00,0x1e,0x00,0x00,0x1e,0x00,0x80,0x6f,0x00,0x80,0x4c,0x00,0x00,0x0c,0x00}; // *
glyph_line_t GLYPH_ATTR chr24_043[] = {0x18,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x80,0x7f,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00}; // +
glyph_line_t GLYPH_ATTR chr24_044[] = {0x06,0x00,0x80,0x03,0x00,0xc0,0x01}; // ,
glyph_line_t GLYPH_ATTR chr24_045[] = {0x18,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00}; // -
glyph_line_t GLYPH_ATTR chr24_046[] = {0x03,0x00,0xc0,0x01}; // .
glyph_line_t GLYPH_ATTR chr24_047[] = {0x18,0x00,0x00,0x01,0x00,0xc0,0x01,0x00,0x70,0x00,0x00,0x1c,0x00,0x00,0x07,0x00,0xc0,0x01,0x00,0x70,0x00,0x00,0x10,0x00,0x00}; // /
glyph_line_t GLYPH_ATTR chr24_048[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x30,0x03,0x30,0x18,0x03,0x30,0x0c,0x03,0x30,0x06,0x03,0x30,0x03,0x03,0xe0,0xff,0x01}; // 0
glyph_line_t GLYPH_ATTR chr24_049[] = {0x0f,0xc0,0x00,0x03,0x60,0x00,0x03,0xf0,0xff,0x03,0x00,0x00,0x03,0x00,0x00,0x03}; // 1
glyph_line_t GLYPH_ATTR chr24_050[] = {0x18,0xc0,0x01,0x03,0xe0,0x81,0x03,0x30,0xc0,0x03,0x30,0x60,0x03,0x30,0x30,0x03,0x30,0x18,0x03,0x30,0x0c,0x03,0xe0,0x07,0x03}; // 2
glyph_line_t GLYPH_ATTR chr24_051[] = {0x18,0xc0,0x80,0x00,0xe0,0x80,0x01,0x30,0x0c,0x01,0x30,0x0c,0x01,0x30,0x0c,0x01,0x30,0x0c,0x03,0x30,0x0c,0x01,0xe0,0xff,0x01}; // 3
glyph_line_t GLYPH_ATTR chr24_052[] = {0x18,0x00,0x38,0x00,0x00,0x3c,0x00,0x00,0x26,0x00,0x00,0x23,0x00,0x80,0x21,0x00,0xc0,0x20,0x00,0x60,0x20,0x00,0xf0,0xff,0x03}; // 4
glyph_line_t GLYPH_ATTR chr24_053[] = {0x18,0xf0,0x87,0x00,0xf0,0x87,0x01,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0xf8,0x01}; // 5
glyph_line_t GLYPH_ATTR chr24_054[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0xf8,0x01}; // 6
glyph_line_t GLYPH_ATTR chr24_055[] = {0x18,0xf0,0x00,0x00,0xf0,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0xf0,0x03,0x30,0x0c,0x00,0x30,0x03,0x00,0xf0,0x01,0x00}; // 7
glyph_line_t GLYPH_ATTR chr24_056[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0xe0,0xff,0x01}; // 8
glyph_line_t GLYPH_ATTR chr24_057[] = {0x18,0xc0,0x07,0x00,0xe0,0x0f,0x03,0x30,0x08,0x03,0x30,0x08,0x03,0x30,0x08,0x03,0x30,0x08,0x03,0x30,0x08,0x03,0xe0,0xff,0x01}; // 9
glyph_line_t GLYPH_ATTR chr24_058[] = {0x03,0x00,0x87,0x03}; // :
glyph_line_t GLYPH_ATTR chr24_059[] = {0x06,0x00,0x00,0x07,0x00,0x87,0x03}; // ;
glyph_line_t GLYPH_ATTR chr24_060[] = {0x15,0x00,0x0c,0x00,0x00,0x3f,0x00,0x80,0x61,0x00,0xc0,0xc0,0x00,0x60,0x80,0x01,0x30,0x00,0x03,0x10,0x00,0x02}; // <
glyph_line_t GLYPH_ATTR chr24_061[] = {0x18,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00,0x00,0x33,0x00}; // =
glyph_line_t GLYPH_ATTR chr24_062[] = {0x18,0x10,0x00,0x02,0x30,0x00,0x03,0x60,0x80,0x01,0xc0,0xc0,0x00,0x80,0x61,0x00,0x00,0x33,0x00,0x00,0x1e,0x00,0x00,0x0c,0x00}; // >
glyph_line_t GLYPH_ATTR chr24_063[] = {0x18,0xc0,0x01,0x00,0xe0,0x01,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x98,0x03,0x30,0x0c,0x00,0x30,0x06,0x00,0xe0,0x03,0x00}; // ?
glyph_line_t GLYPH_ATTR chr24_064[] = {0x18,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x3f,0x03,0xb0,0x3b,0x03,0xb0,0x60,0x03,0xb0,0x60,0x03,0xb0,0x60,0x03,0xe0,0x7f,0x03}; // @
glyph_line_t GLYPH_ATTR chr24_065[] = {0x18,0xc0,0xff,0x03,0xe0,0xff,0x03,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0xe0,0xff,0x03}; // A
glyph_line_t GLYPH_ATTR chr24_066[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x04,0x03,0x30,0x06,0x03,0x30,0x0e,0x03,0xe0,0xf9,0x01}; // B
glyph_line_t GLYPH_ATTR chr24_067[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x00,0x03,0x20,0x00,0x01,0x20,0x00,0x01,0x60,0x80,0x01,0xe0,0xc0,0x01}; // C
glyph_line_t GLYPH_ATTR chr24_068[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x60,0x80,0x01,0xc0,0xff,0x00}; // D
glyph_line_t GLYPH_ATTR chr24_069[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x0c,0x03,0x30,0x00,0x03,0x30,0x00,0x03}; // E
glyph_line_t GLYPH_ATTR chr24_070[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x0c,0x00,0x30,0x0c,0x00,0x30,0x0c,0x00,0x30,0x0c,0x00,0x30,0x00,0x00,0x30,0x00,0x00}; // F
glyph_line_t GLYPH_ATTR chr24_071[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x00,0x03,0x20,0x0c,0x03,0x20,0x0c,0x03,0x60,0x0c,0x03,0xe0,0xfc,0x01}; // G
glyph_line_t GLYPH_ATTR chr24_072[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0xf0,0xff,0x03}; // H
glyph_line_t GLYPH_ATTR chr24_073[] = {0x0c,0x30,0x00,0x03,0x30,0x00,0x03,0xf0,0xff,0x03,0x30,0x00,0x03}; // I
glyph_line_t GLYPH_ATTR chr24_074[] = {0x1b,0x00,0xc0,0x00,0x00,0xc0,0x01,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x30,0x00,0x03,0xf0,0xff,0x01,0xf0,0xff,0x00,0x30,0x00,0x00}; // J
glyph_line_t GLYPH_ATTR chr24_075[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x1e,0x00,0x00,0x33,0x00,0x80,0x61,0x00,0xc0,0xc0,0x00,0x60,0x80,0x01,0x30,0x00,0x03}; // K
glyph_line_t GLYPH_ATTR chr24_076[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03}; // L
glyph_line_t GLYPH_ATTR chr24_077[] = {0x18,0xf0,0xff,0x03,0xc0,0x00,0x00,0x80,0x01,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x80,0x01,0x00,0x40,0x00,0x00,0xf0,0xff,0x03}; // M
glyph_line_t GLYPH_ATTR chr24_078[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x03,0x00,0x00,0x06,0x00,0x00,0x0c,0x00,0x00,0x18,0x00,0x00,0x30,0x00,0xf0,0xff,0x03}; // N
glyph_line_t GLYPH_ATTR chr24_079[] = {0x18,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0xe0,0xff,0x01}; // O
glyph_line_t GLYPH_ATTR chr24_080[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0x30,0x08,0x00,0xe0,0x07,0x00}; // P
glyph_line_t GLYPH_ATTR chr24_081[] = {0x1b,0xc0,0xff,0x00,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x80,0x03,0x30,0x80,0x03,0x30,0x00,0x03,0xe0,0xff,0x07,0x00,0x00,0x04}; // Q
glyph_line_t GLYPH_ATTR chr24_082[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x30,0x18,0x00,0x30,0x38,0x00,0x30,0x68,0x00,0x30,0xc8,0x00,0x30,0x88,0x01,0xe0,0x07,0x03}; // R
glyph_line_t GLYPH_ATTR chr24_083[] = {0x18,0xc0,0x83,0x00,0xe0,0x87,0x01,0x30,0x0c,0x01,0x30,0x0c,0x01,0x20,0x0c,0x01,0x20,0x0c,0x03,0x60,0x0c,0x01,0xe0,0xf8,0x01}; // S
glyph_line_t GLYPH_ATTR chr24_084[] = {0x18,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0xf0,0xff,0x03,0x30,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00}; // T
glyph_line_t GLYPH_ATTR chr24_085[] = {0x18,0xf0,0xff,0x00,0xf0,0xff,0x01,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0xf0,0xff,0x01}; // U
glyph_line_t GLYPH_ATTR chr24_086[] = {0x18,0x70,0x00,0x00,0xe0,0x0f,0x00,0x00,0x7c,0x00,0x00,0x80,0x03,0x00,0x00,0x03,0x00,0xe0,0x01,0x00,0x1f,0x00,0xf0,0x03,0x00}; // V
glyph_line_t GLYPH_ATTR chr24_087[] = {0x18,0xf0,0xff,0x03,0x00,0xc0,0x00,0x00,0x60,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x60,0x00,0x00,0x80,0x00,0xf0,0xff,0x03}; // W
glyph_line_t GLYPH_ATTR chr24_088[] = {0x18,0x10,0x00,0x02,0xe0,0xc0,0x01,0x80,0x73,0x00,0x00,0x1e,0x00,0x00,0x0c,0x00,0x00,0x3f,0x00,0xc0,0xe1,0x00,0x30,0x00,0x03}; // X
glyph_line_t GLYPH_ATTR chr24_089[] = {0x18,0x30,0x00,0x00,0xe0,0x00,0x00,0x80,0x03,0x00,0x00,0x0c,0x00,0x00,0xfc,0x03,0x00,0x06,0x00,0xc0,0x01,0x00,0x70,0x00,0x00}; // Y
glyph_line_t GLYPH_ATTR chr24_090[] = {0x18,0x30,0xc0,0x03,0x30,0xe0,0x03,0x30,0x30,0x03,0x30,0x18,0x03,0x30,0x0c,0x03,0x30,0x06,0x03,0x30,0x03,0x03,0xf0,0x01,0x03}; // Z
glyph_line_t GLYPH_ATTR chr24_091[] = {0x0c,0xf0,0xff,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03}; // [
glyph_line_t GLYPH_ATTR chr24_092[] = {0x15,0x30,0x00,0x00,0xe0,0x00,0x00,0x80,0x03,0x00,0x00,0x0e,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x80,0x01}; // backslash
glyph_line_t GLYPH_ATTR chr24_093[] = {0x0c,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03,0xf0,0xff,0x03}; // ]
glyph_line_t GLYPH_ATTR chr24_094[] = {0x15,0x40,0x00,0x00,0x20,0x00,0x00,0x38,0x00,0x00,0x18,0x00,0x00,0x30,0x00,0x00,0x60,0x00,0x00,0x40,0x00,0x00}; // ^
glyph_line_t GLYPH_ATTR chr24_095[] = {0x18,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,0x00,0x0c}; // _
glyph_line_t GLYPH_ATTR chr24_096[] = {0x0c,0x02,0x00,0x00,0x06,0x00,0x00,0x0c,0x00,0x00,0x08,0x00,0x00}; // `
glyph_line_t GLYPH_ATTR chr24_097[] = {0x18,0x00,0xe0,0x00,0x00,0xf3,0x01,0x00,0x13,0x03,0x00,0x13,0x03,0x00,0x13,0x03,0x00,0x13,0x03,0x00,0x13,0x03,0x00,0xfe,0x03}; // a
glyph_line_t GLYPH_ATTR chr24_098[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0xfe,0x01}; // b
glyph_line_t GLYPH_ATTR chr24_099[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x01,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x86,0x01}; // c
glyph_line_t GLYPH_ATTR chr24_100[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x01,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0xf0,0xff,0x03}; // d
glyph_line_t GLYPH_ATTR chr24_101[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x01,0x00,0x33,0x03,0x00,0x33,0x03,0x00,0x33,0x01,0x00,0x33,0x01,0x00,0x33,0x01,0x00,0x3e,0x01}; // e
glyph_line_t GLYPH_ATTR chr24_102[] = {0x18,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0xe0,0xff,0x03,0x30,0x03,0x00,0x30,0x03,0x00,0x30,0x03,0x00,0x30,0x00,0x00}; // f
glyph_line_t GLYPH_ATTR chr24_103[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x11,0x00,0x03,0x1b,0x00,0x03,0x1b,0x00,0x03,0x1b,0x00,0x03,0x1b,0x00,0x03,0x1b,0x00,0xff,0x0f}; // g
glyph_line_t GLYPH_ATTR chr24_104[] = {0x18,0xf0,0xff,0x03,0xf0,0xff,0x03,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0xfe,0x03}; // h
glyph_line_t GLYPH_ATTR chr24_105[] = {0x0c,0x00,0x03,0x03,0x00,0x03,0x03,0x70,0xff,0x03,0x00,0x00,0x03}; // i
glyph_line_t GLYPH_ATTR chr24_106[] = {0x15,0x00,0x00,0x0e,0x00,0x00,0x18,0x00,0x00,0x10,0x00,0x00,0x18,0x00,0x03,0x18,0x70,0xff,0x0f,0x70,0xff,0x07}; // j
glyph_line_t GLYPH_ATTR chr24_107[] = {0x15,0xf0,0xff,0x03,0x00,0x30,0x00,0x00,0x78,0x00,0x00,0xcc,0x00,0x00,0x86,0x01,0x00,0x03,0x01,0x00,0x01,0x02}; // k
glyph_line_t GLYPH_ATTR chr24_108[] = {0x0c,0x30,0x00,0x03,0x30,0x00,0x03,0xf0,0xff,0x03,0x00,0x00,0x03}; // l
glyph_line_t GLYPH_ATTR chr24_109[] = {0x18,0x00,0xff,0x03,0x00,0xff,0x03,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0xff,0x03,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0xfe,0x03}; // m
glyph_line_t GLYPH_ATTR chr24_110[] = {0x18,0x00,0xff,0x03,0x00,0xff,0x03,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0xfe,0x03}; // n
glyph_line_t GLYPH_ATTR chr24_111[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x01,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0xfe,0x01}; // o
glyph_line_t GLYPH_ATTR chr24_112[] = {0x18,0x00,0xff,0x1f,0x00,0xff,0x1f,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0xfe,0x01}; // p
glyph_line_t GLYPH_ATTR chr24_113[] = {0x18,0x00,0xfc,0x00,0x00,0xfe,0x01,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0xff,0x1f}; // q
glyph_line_t GLYPH_ATTR chr24_114[] = {0x18,0x00,0xff,0x03,0x00,0xff,0x03,0x00,0x06,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00}; // r
glyph_line_t GLYPH_ATTR chr24_115[] = {0x18,0x00,0x0c,0x00,0x00,0x1e,0x01,0x00,0x33,0x03,0x00,0x33,0x03,0x00,0x33,0x01,0x00,0x33,0x01,0x00,0x23,0x01,0x00,0xe2,0x01}; // s
glyph_line_t GLYPH_ATTR chr24_116[] = {0x18,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0xf0,0xff,0x01,0x00,0xc3,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x00,0x03}; // t
glyph_line_t GLYPH_ATTR chr24_117[] = {0x18,0x00,0xff,0x00,0x00,0xff,0x01,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0xff,0x03}; // u
glyph_line_t GLYPH_ATTR chr24_118[] = {0x18,0x00,0x03,0x00,0x00,0x1e,0x00,0x00,0xf0,0x00,0x00,0x80,0x03,0x00,0x00,0x03,0x00,0xc0,0x01,0x00,0x3c,0x00,0x00,0x07,0x00}; // v
glyph_line_t GLYPH_ATTR chr24_119[] = {0x18,0x00,0xff,0x00,0x00,0xff,0x01,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0xf8,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0xff,0x01}; // w
glyph_line_t GLYPH_ATTR chr24_120[] = {0x18,0x00,0x03,0x03,0x00,0x86,0x01,0x00,0xcc,0x00,0x00,0x78,0x00,0x00,0x30,0x00,0x00,0x78,0x00,0x00,0xce,0x00,0x00,0x87,0x03}; // x
glyph_line_t GLYPH_ATTR chr24_121[] = {0x18,0x00,0xff,0x00,0x00,0xff,0x11,0x00,0x00,0x1b,0x00,0x00,0x1b,0x00,0x00,0x1b,0x00,0x00,0x1b,0x00,0x00,0x1b,0x00,0xff,0x0f}; // y
glyph_line_t GLYPH_ATTR chr24_122[] = {0x18,0x00,0x03,0x03,0x00,0x83,0x03,0x00,0xc3,0x03,0x00,0x63,0x03,0x00,0x33,0x03,0x00,0x1b,0x03,0x00,0x0f,0x03,0x00,0x07,0x03}; // z
glyph_line_t GLYPH_ATTR chr24_123[] = {0x12,0x00,0x0c,0x00,0x00,0x0c,0x00,0xe0,0xff,0x01,0x30,0x00,0x03,0x30,0x00,0x03,0x30,0x00,0x03}; // {
glyph_line_t GLYPH_ATTR chr24_124[] = {0x03,0xf0,0xff,0x03}; // |
glyph_line_t GLYPH_ATTR chr24_125[] = {0x12,0x30,0x00,0x03,0x30,0x00,0x03,0x60,0x80,0x01,0xc0,0xff,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00}; // }
glyph_line_t GLYPH_ATTR chr24_126[] = {0x18,0x60,0x00,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x18,0x00,0x00,0x30,0x00,0x00,0x60,0x00,0x00,0x60,0x00,0x00,0x38,0x00,0x00}; // ~


const glyph_t terminus24[] GLYPH_ATTR = {
	chr24_032,
	chr24_033,
	chr24_034,
	chr24_035,
	chr24_036,
	chr24_037,
	chr24_038,
	chr24_039,
	chr24_040,
	chr24_041,
	chr24_042,
	chr24_043,
	chr24_044,
	chr24_045,
	chr24_046,
	chr24_047,
	chr24_048,
	chr24_049,
	chr24_050,
	chr24_051,
	chr24_052,
	chr24_053,
	chr24_054,
	chr24_055,
	chr24_056,
	chr24_057,
	chr24_058,
	chr24_059,
	chr24_060,
	chr24_061,
	chr24_062,
	chr24_063,
	chr24_064,
	chr24_065,
	chr24_066,
	chr24_067,
	chr24_068,
	chr24_069,
	chr24_070,
	chr24_071,
	chr24_072,
	chr24_073,
	chr24_074,
	chr24_075,
	chr24_076,
	chr24_077,
	chr24_078,
	chr24_079,
	chr24_080,
	chr24_081,
	chr24_082,
	chr24_083,
	chr24_084,
	chr24_085,
	chr24_086,
	chr24_087,
	chr24_088,
	chr24_089,
	chr24_090,
	chr24_091,
	chr24_092,
	chr24_093,
	chr24_094,
	chr24_095,
	chr24_096,
	chr24_097,
	chr24_098,
	chr24_099,
	chr24_100,
	chr24_101,
	chr24_102,
	chr24_103,
	chr24_104,
	chr24_105,
	chr24_106,
	chr24_107,
	chr24_108,
	chr24_109,
	chr24_110,
	chr24_111,
	chr24_112,
	chr24_113,
	chr24_114,
	chr24_115,
	chr24_116,
	chr24_117,
	chr24_118,
	chr24_119,
	chr24_120,
	chr24_121,
	chr24_122,
	chr24_123,
	chr24_124,
	chr24_125,
	chr24_126
};
